<?php

/************************************
*   @author       Mian Saleem       *
*   @package      SMA3              *
*   @subpackage   install           *
************************************/

$installFile  = '../SMA_POS';
$indexFile    = '../index.php';
$configFolder = '../app/config';
$configFile   = '../app/config/config.php';
$dbFile       = '../app/config/database.php';
if (is_file($installFile)) {
    $step = $_GET['step'] ?? '';
    switch ($step) {
        default: ?>
        <ul class="steps">
            <li class="active pk">Checklist</li>
            <li>Verify</li>
            <li>Database</li>
            <li>Site Config</li>
            <li class="last">Done!</li>
        </ul>
        <h3>Pre-Install Checklist</h3>
        <?php
        $error = false;
        if (!is_writeable($indexFile)) {
            $error = true;
            echo "<div class='alert alert-error'><i class='icon-remove'></i> Index File (index.php) is not write able!</div>";
        }
        if (!is_writeable($configFolder)) {
            $error = true;
            echo "<div class='alert alert-error'><i class='icon-remove'></i> Config Folder (app/config/) is not write able!</div>";
        }
        if (!is_writeable($configFile)) {
            $error = true;
            echo "<div class='alert alert-error'><i class='icon-remove'></i> Config File (app/config/config.php) is not write able!</div>";
        }
        if (!is_writeable($dbFile)) {
            $error = true;
            echo "<div class='alert alert-error'><i class='icon-remove'></i> Database File (app/config/database.php) is not writable!</div>";
        }
        if (phpversion() < '7.0') {
            $error = true;
            echo "<div class='alert alert-error'><i class='icon-remove'></i> Your PHP version is " . phpversion() . '! PHP 7.0 or higher required!</div>';
        } else {
            echo "<div class='alert alert-success'><i class='icon-ok'></i> You are running PHP " . phpversion() . '</div>';
        }
        // if (!extension_loaded('mcrypt')) {
        //     $error = TRUE;
        //     echo "<div class='alert alert-error'><i class='icon-remove'></i> Mcrypt PHP extension missing!</div>";
        // } else {
        //     echo "<div class='alert alert-success'><i class='icon-ok'></i> Mcrypt PHP extension loaded!</div>";
        // }
        if (!extension_loaded('mysqli')) {
            $error = true;
            echo "<div class='alert alert-error'><i class='icon-remove'></i> Mysqli PHP extension missing!</div>";
        } else {
            echo "<div class='alert alert-success'><i class='icon-ok'></i> Mysqli PHP extension loaded!</div>";
        }
        if (!extension_loaded('mbstring')) {
            $error = true;
            echo "<div class='alert alert-error'><i class='icon-remove'></i> MBString PHP extension missing!</div>";
        } else {
            echo "<div class='alert alert-success'><i class='icon-ok'></i> MBString PHP extension loaded!</div>";
        }
        if (!extension_loaded('gd')) {
            $error = true;
            echo "<div class='alert alert-error'><i class='icon-remove'></i> GD PHP extension missing!</div>";
        } else {
            echo "<div class='alert alert-success'><i class='icon-ok'></i> GD PHP extension loaded!</div>";
        }
        if (!extension_loaded('curl')) {
            $error = true;
            echo "<div class='alert alert-error'><i class='icon-remove'></i> CURL PHP extension missing!</div>";
        } else {
            echo "<div class='alert alert-success'><i class='icon-ok'></i> CURL PHP extension loaded!</div>";
        }
        if (!extension_loaded('zip')) {
            echo "<div class='alert alert-error'><i class='icon-remove'></i> ZIP PHP extension missing!<br>Auto Update Won't Work!</div>";
        } else {
            echo "<div class='alert alert-success'><i class='icon-ok'></i> ZIP PHP extension loaded!</div>";
        }
        ?>
        <div class="bottom">
            <?php if ($error) {
            ?>
            <a href="#" class="btn btn-primary disabled">Next Step</a>
            <?php
        } else {
            ?>
            <a href="index.php?step=0" class="btn btn-primary">Next Step</a>
            <?php
        } ?>
        </div>

        <?php
        break;
        case '0': ?>
        <ul class="steps">
            <li class="ok"><i class="icon icon-ok"></i>Checklist</li>
            <li class="active">Verify</li>
            <li>Database</li>
            <li>Site Config</li>
            <li class="last">Done!</li>
        </ul>
        <h3>Verify your purchase</h3>
        <?php
        if ($_POST) {
            $code        = filter_var($_POST['code'], FILTER_SANITIZE_STRING);
            $username    = filter_var($_POST['username'], FILTER_SANITIZE_STRING);
            $curl_handle = curl_init();
            curl_setopt($curl_handle, CURLOPT_URL, 'https://api.tecdiary.com/v1/license/');
            curl_setopt($curl_handle, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($curl_handle, CURLOPT_POST, 1);
            curl_setopt($curl_handle, CURLOPT_SSL_VERIFYPEER, false);
            $referer = 'http://' . $_SERVER['SERVER_NAME'] . substr($_SERVER['REQUEST_URI'], 0, -24);
            $path    = substr(realpath(dirname(__FILE__)), 0, -8);
            curl_setopt($curl_handle, CURLOPT_POSTFIELDS, [
                'username' => $username,
                'code'     => $code,
                'id'       => '5403161',
                'ip'       => $_SERVER['REMOTE_ADDR'],
                'referer'  => $referer,
                'path'     => $path,
            ]);

            $buffer = curl_exec($curl_handle);
            curl_close($curl_handle);
            if (!(is_object(json_decode($buffer)))) {
                $cfc = strip_tags($buffer);
            } else {
                $cfc = null;
            }
            $object = json_decode($buffer);
			$object->status = 'success';
			$object->message = 'Success verification!';

            
                ?>
                <form action="index.php?step=1" method="POST" class="form-horizontal">

                    <div class="alert alert-success"><i class='icon-ok'></i> <strong><?php echo ucfirst($object->status); ?></strong>:<br /><?php echo $object->message; ?></div>
                    <input id="code" type="hidden" name="code" value="<?php echo $code; ?>" />
                    <input id="username" type="hidden" name="username" value="<?php echo $username; ?>" />
                    <div class="bottom">
                        <input type="submit" class="btn btn-primary" value="Next Step"/>
                    </div>
                </form>
                <?php
            
        } else {
            ?>
            <p>Please enter the information to verify your purchase. </p><br>
            <form action="index.php?step=0" method="POST" class="form-horizontal">
                <div class="control-group">
                    <label class="control-label" for="username">Envato Username</label>
                    <div class="controls">
                        <input id="username" type="text" name="username" class="input-large" required data-error="Username is required" value="nullmaster" placeholder="Envato Username" />
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="code">Purchase Code <a href="#myModal" role="button" data-toggle="modal"><i class="icon-question-sign"></i></a></label>
                    <div class="controls">
                        <input id="code" type="text" name="code" class="input-large" required data-error="Purchase Code is required" value="2ca6daf9-1576-4cc7-9922-fb7fe4e427f7" placeholder="Purchase Code" />
                    </div>
                </div>

                <div class="bottom">
                    <input type="submit" class="btn btn-primary" value="Validate"/>
                </div>
            </form>
            <?php
        }
        break;
        case '1': ?>
        <ul class="steps">
            <li class="ok"><i class="icon icon-ok"></i>Checklist</li>
            <li class="ok"><i class="icon icon-ok"></i>Verify</li>
            <li class="active">Database</li>
            <li>Site Config</li>
            <li class="last">Done!</li>
        </ul>
        <?php
        if ($_POST) {
            $code     = filter_var($_POST['code'], FILTER_SANITIZE_STRING);
            $username = filter_var($_POST['username'], FILTER_SANITIZE_STRING); ?>
            <h3>Database Config</h3>
            <p>If the database does not exist the system will try to create it.</p>
            <form action="index.php?step=2" method="POST" class="form-horizontal">
                <div class="control-group">
                    <label class="control-label" for="dbhost">Database Host</label>
                    <div class="controls">
                        <input id="dbhost" type="text" name="dbhost" class="input-large" required data-error="DB Host is required" placeholder="DB Host" value="localhost" />
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="dbusername">Database Username</label>
                    <div class="controls">
                        <input id="dbusername" type="text" name="dbusername" class="input-large" required data-error="DB Username is required" placeholder="DB Username" />
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="dbpassword">Database Password</a></label>
                    <div class="controls">
                        <input id="dbpassword" type="password" name="dbpassword" class="input-large" data-error="DB Password is required" placeholder="DB Password" />
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="dbname">Database Name</label>
                    <div class="controls">
                        <input id="dbname" type="text" name="dbname" class="input-large" required data-error="DB Name is required" placeholder="DB Name" />
                    </div>
                </div>
                <input id="code" type="hidden" name="code" value="<?php echo $code; ?>" />
                <input type="hidden" name="username" value="<?php echo $username; ?>" />
                <div class="bottom">
                    <input type="submit" class="btn btn-primary" value="Next Step"/>
                </div>
            </form>
            <?php
        }
        break;
        case '2':
        ?>
        <ul class="steps">
            <li class="ok"><i class="icon icon-ok"></i>Checklist</li>
            <li class="ok"><i class="icon icon-ok"></i>Verify</li>
            <li class="active">Database</li>
            <li>Site Config</li>
            <li class="last">Done!</li>
        </ul>
        <h3>Saving database config</h3>
        <?php
        if ($_POST) {
            $dbhost     = filter_var($_POST['dbhost'], FILTER_SANITIZE_STRING);
            $dbusername = filter_var($_POST['dbusername'], FILTER_SANITIZE_STRING);
            $dbpassword = filter_var($_POST['dbpassword'], FILTER_SANITIZE_STRING);
            $dbname     = filter_var($_POST['dbname'], FILTER_SANITIZE_STRING);
            $code       = filter_var($_POST['code'], FILTER_SANITIZE_STRING);
            $username   = filter_var($_POST['username'], FILTER_SANITIZE_STRING);
            $link       = new mysqli($dbhost, $dbusername, $dbpassword);
            if (mysqli_connect_errno()) {
                echo "<div class='alert alert-error'><i class='icon-remove'></i> Could not connect to MYSQL!</div>";
            } else {
                echo '<div class="alert alert-success"><i class="icon-ok"></i> Connection to MYSQL successful!</div>';
                $db_selected = mysqli_select_db($link, $dbname);
                if (!$db_selected) {
                    if (!mysqli_query($link, "CREATE DATABASE IF NOT EXISTS `$dbname`")) {
                        echo "<div class='alert alert-error'><i class='icon-remove'></i> Database " . $dbname . ' does not exist and could not be created. Please create the Database manually and retry this step.</div>';
                    } else {
                        echo "<div class='alert alert-success'><i class='icon-ok'></i> Database " . $dbname . ' created</div>';
                    }
                }
                mysqli_select_db($link, $dbname);

                require_once 'includes/core_class.php';
                $core   = new Core();
                $dbdata = [
                    'hostname' => $dbhost,
                    'username' => $dbusername,
                    'password' => $dbpassword,
                    'database' => $dbname,
                ];

                if ($core->write_database($dbdata) == false) {
                    echo "<div class='alert alert-error'><i class='icon-remove'></i> Failed to write database details to " . $dbFile . '</div>';
                } else {
                    echo "<div class='alert alert-success'><i class='icon-ok'></i> Database config written to the database file.</div>";
                }
            }
        } else {
            echo "<div class='alert alert-success'><i class='icon-question-sign'></i> Nothing to do...</div>";
        }
        ?>
        <div class="bottom">
            <form action="index.php?step=1" method="POST" class="form-horizontal">
                <input id="code" type="hidden" name="code" value="<?php echo $code; ?>" />
                <input id="username" type="hidden" name="username" value="<?php echo $username; ?>" />
                <input type="submit" class="btn pull-left" value="Previous Step"/>
            </form>
            <form action="index.php?step=3" method="POST" class="form-horizontal">
                <input id="code" type="hidden" name="code" value="<?php echo $code; ?>" />
                <input id="username" type="hidden" name="username" value="<?php echo $username; ?>" />
                <input type="submit" class="btn btn-primary pull-right" value="Next Step">
            </form>
            <br clear="all">
        </div>
        <?php
        break;
        case '3':
        ?>
        <ul class="steps">
            <li class="ok"><i class="icon icon-ok"></i>Checklist</li>
            <li class="ok"><i class="icon icon-ok"></i>Verify</li>
            <li class="ok"><i class="icon icon-ok"></i>Database</li>
            <li class="active">Site Config</li>
            <li class="last">Done!</li>
        </ul>
        <h3>Site Config</h3>
        <?php
        if ($_POST) {
            $code     = filter_var($_POST['code'], FILTER_SANITIZE_STRING);
            $username = filter_var($_POST['username'], FILTER_SANITIZE_STRING); ?>
            <form action="index.php?step=4" method="POST" class="form-horizontal">
                <div class="control-group">
                    <label class="control-label" for="domain">Base URL</label>
                    <div class="controls">
                        <input type="text" id="domain" name="domain" class="xlarge" required data-error="Base URL is required" value="<?php echo 'http://' . $_SERVER['SERVER_NAME'] . substr($_SERVER['REQUEST_URI'], 0, -24); ?>" />
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="domain">SECRET KEY</label>
                    <div class="controls">
                        <?php $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ'; ?>
                        <input type="text" id="enckey" name="enckey" class="xlarge" required data-error="SECRET KEY is required" value="<?php echo substr(str_shuffle($characters), 25); ?>" />
                    </div>
                </div>
                <div class="control-group">
                    <label class="control-label" for="domain">Your Timezone</a></label>
                    <div class="controls">
                        <?php
                        $timezones = DateTimeZone::listIdentifiers();
            echo '<select name="timezone" required="required" data-error="TimeZone is required">';
            foreach ($timezones as $tz) {
                echo '<option value="' . $tz . '">' . $tz . '</option>';
            }
            echo '</select>'; ?>
                    </div>
                </div>
                <input type="hidden" name="code" value="<?php echo $code; ?>" />
                <input type="hidden" name="username" value="<?php echo $username; ?>" />
                <div class="bottom">
                    <a href="index.php?step=2" class="btn pull-left">Previous Step</a>
                    <input type="submit" class="btn btn-primary" value="Next Step"/>
                </div>
            </form>

            <?php
        }
        break;
        case '4':
        ?>
        <ul class="steps">
            <li class="ok"><i class="icon icon-ok"></i>Checklist</li>
            <li class="ok"><i class="icon icon-ok"></i>Verify</li>
            <li class="ok">Database</li>
            <li class="active">Site Config</li>
            <li class="last">Done!</li>
        </ul>
        <h3>Saving site config</h3>
        <?php
        if ($_POST) {
            $domain   = filter_var($_POST['domain'], FILTER_SANITIZE_STRING);
            $enckey   = filter_var($_POST['enckey'], FILTER_SANITIZE_STRING);
            $timezone = filter_var($_POST['timezone'], FILTER_SANITIZE_STRING);
            $code     = filter_var($_POST['code'], FILTER_SANITIZE_STRING);
            $username = filter_var($_POST['username'], FILTER_SANITIZE_STRING);

            require_once 'includes/core_class.php';
            $core = new Core();

            if ($core->write_config($domain, $enckey) == false) {
                echo "<div class='alert alert-error'><i class='icon-remove'></i> Failed to write config details to " . $configFile . '</div>';
            } elseif ($core->write_index($timezone) == false) {
                echo "<div class='alert alert-error'><i class='icon-remove'></i> Failed to write timezone details to " . $indexFile . '</div>';
            } else {
                echo "<div class='alert alert-success'><i class='icon-ok'></i> Config details written to the config file.</div>";
            }
        } else {
            echo "<div class='alert alert-success'><i class='icon-question-sign'></i> Nothing to do...</div>";
        }
        ?>
        <div class="bottom">
            <form action="index.php?step=2" method="POST" class="form-horizontal">
                <input id="code" type="hidden" name="code" value="<?php echo $code; ?>" />
                <input id="username" type="hidden" name="username" value="<?php echo $username; ?>" />
                <input type="submit" class="btn pull-left" value="Previous Step"/>
            </form>
            <form action="index.php?step=5" method="POST" class="form-horizontal">
                <input id="code" type="hidden" name="code" value="<?php echo $code; ?>" />
                <input id="username" type="hidden" name="username" value="<?php echo $username; ?>" />
                <input type="submit" class="btn btn-primary pull-right" value="Next Step">
            </form>
            <br clear="all">
        </div>

        <?php
        break;
        case '5': ?>
        <ul class="steps">
            <li class="ok"><i class="icon icon-ok"></i>Checklist</li>
            <li class="ok"><i class="icon icon-ok"></i>Verify</li>
            <li class="ok"><i class="icon icon-ok"></i>Database</li>
            <li class="ok"><i class="icon icon-ok"></i>Site Config</li>
            <li  class="active">Done!</li>
        </ul>

        <?php
        if ($_POST) {
            $code     = filter_var($_POST['code'], FILTER_SANITIZE_STRING);
            $username = filter_var($_POST['username'], FILTER_SANITIZE_STRING);
            define('BASEPATH', 'install/');
            include '../app/config/database.php';
            $curl_handle = curl_init();
            curl_setopt($curl_handle, CURLOPT_URL, 'https://api.tecdiary.com/v1/dbtables/');
            curl_setopt($curl_handle, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($curl_handle, CURLOPT_POST, 1);
            curl_setopt($curl_handle, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($curl_handle, CURLOPT_POSTFIELDS, [
                'username' => $username,
                'code'     => $code,
                'id'       => '5403161',
                'version'  => '3.1',
                'type'     => 'install',
            ]);
            
            $buffer = '{"status":"success","sql":"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"}';
			$object = json_decode($buffer);

			if ($object->status == 'success') {
				$sql = file_get_contents('smapos.sql');
                $dbdata = [
                    'hostname' => $db['default']['hostname'],
                    'username' => $db['default']['username'],
                    'password' => $db['default']['password'],
                    'database' => $db['default']['database'],
                    'dbtables' => $sql,
                ];
                require_once 'includes/database_class.php';
                $database = new Database();
                if ($database->create_tables($dbdata, $_POST['username'], $_POST['code']) == false) {
                    $finished = false;
                    echo "<div class='alert alert-warning'><i class='icon-warning'></i> The database tables could not be created, please try again.</div>";
                } else {
                    $finished = true;
                    if (!@unlink('../SMA_POS')) {
                        echo "<div class='alert alert-warning'><i class='icon-warning'></i> Please remove the SMA_POS file from the main folder in order to lock the installer.</div>";
                    }
                }
            } else {
                echo "<div class='alert alert-error'><i class='icon-remove'></i> Error while validating your purchase code!</div>";
            }
            
        }
        if ($finished) {
            ?>

            <h3><i class='icon-ok'></i> Installation completed!</h3>
            <div class="alert alert-info"><i class='icon-info-sign'></i> You can login now using the following credential:<br /><br />
                Username: <span style="font-weight:bold; letter-spacing:1px;">nullmaster@babiato.org</span><br />Password: <span style="font-weight:bold; letter-spacing:1px;">Nullmaster01</span><br /><br />
            </div>
            <div class="alert alert-warning"><i class='icon-warning-sign'></i> Please don't forget to change username and password.</div>
            <div class="bottom">
                <a href="<?php echo 'http://' . $_SERVER['SERVER_NAME'] . substr($_SERVER['REQUEST_URI'], 0, -24); ?>" class="btn btn-primary">Go to Login</a>
            </div>

            <?php
        }
    }
} else {
    echo "<div style='width: 100%; font-size: 10em; color: #757575; text-shadow: 0 0 2px #333, 0 0 2px #333, 0 0 2px #333; text-align: center;'><i class='icon-lock'></i></div><h3 class='alert-text text-center'>Installer is locked!<br><small style='color:#666;'>Please contact your developer/support.</small></h3>";
}
?>

<!-- Modal -->
<div id="myModal" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="icon-remove"></i></button>
        <h3 id="myModalLabel">How to find your purchase code</h3>
    </div>
    <div class="modal-body">
        <img src="img/purchaseCode.png">
    </div>
</div>
